/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.validation;

import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.IdentityHashSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import cz.insophy.inplan.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Validator {
    public static final long TIME_TOLERANCE = 60000L;

    private Validator() {
    }

    public static ValidationResult validate(ShopConfiguration shopConfiguration) {
        ArrayList<Problem> res = new ArrayList<Problem>();
        for (Product product : shopConfiguration.getProducts()) {
            for (Actiongram actiongram : product.getActiongrams()) {
                for (Action action : actiongram.getActions()) {
                    List<Workplace> feasibleWps = shopConfiguration.getWorkplaces(action.getCapabilityReq());
                    Validator.checkCumulatives(res, action, feasibleWps);
                }
            }
        }
        return new ValidationResult(res);
    }

    private static void checkCumulatives(List<Problem> res, Action action, List<Workplace> feasibleWps) {
        for (Workplace wp : feasibleWps) {
            if (wp.isCumulative() && !(action instanceof CumulativeAction)) {
                res.add(Problem.createProblem2("02200", action, wp));
            }
            if (wp.isCumulative() || !(action instanceof CumulativeAction)) continue;
            res.add(Problem.createProblem2("02300", action, wp));
        }
    }

    public static ValidationResult validate(Plan plan) {
        ArrayList<Problem> res = new ArrayList<Problem>();
        for (Workplace wp : plan.getShopConf().getWorkplaces()) {
            Validator.checkOverlaps(plan.getWorkplaceSchedule(wp), res);
        }
        Validator.checkRebuilds(plan, res);
        for (Workplace wp : plan.getShopConf().getWorkplaces()) {
            Validator.checkActionLengths(plan.getWorkplaceSchedule(wp), res);
        }
        Validator.checkNegativeStore(plan, res);
        for (Workplace wp : plan.getShopConf().getWorkplaces()) {
            if (!wp.isCumulative()) continue;
            Validator.checkMaxFills(plan.getWorkplaceSchedule(wp), res);
        }
        return new ValidationResult(res);
    }

    private static void checkOverlaps(WorkplaceSchedule ws, List<Problem> res) {
        long latestEnd = Long.MIN_VALUE;
        WorkplaceActivity latestA = null;
        for (WorkplaceActivity wa : ws.activities()) {
            if (latestA != null && latestEnd > wa.getStart()) {
                res.add(Problem.createProblem2("02400", latestA, wa));
            }
            if (wa.getEnd() <= latestEnd) continue;
            latestA = wa;
            latestEnd = wa.getEnd();
        }
    }

    private static void checkRebuilds(Plan plan, List<Problem> res) {
        Tuple<List<RebuildPlannerUtils.Rebuild>, List<RebuildPlannerUtils.Rebuild>> changes = RebuildPlannerUtils.fix2(plan);
        List<RebuildPlannerUtils.Rebuild> deletions = changes.getFirst();
        List<RebuildPlannerUtils.Rebuild> additions = changes.getSecond();
        ArrayList<Tuple<RebuildPlannerUtils.Rebuild, Object>> fixes = Lists.newArrayList();
        for (RebuildPlannerUtils.Rebuild rebuild : deletions) {
            RebuildPlannerUtils.Rebuild reb2 = null;
            Iterator<RebuildPlannerUtils.Rebuild> addIt = additions.iterator();
            while (addIt.hasNext()) {
                RebuildPlannerUtils.Rebuild add = addIt.next();
                if (rebuild.getEnd() != add.getEnd() || rebuild.getWp() != add.getWp()) continue;
                reb2 = add;
                addIt.remove();
                break;
            }
            Tuple<RebuildPlannerUtils.Rebuild, Object> fix = Tuple.create(rebuild, reb2);
            fixes.add(fix);
        }
        for (RebuildPlannerUtils.Rebuild rebuild : additions) {
            Tuple<Object, RebuildPlannerUtils.Rebuild> fix = Tuple.create(null, rebuild);
            fixes.add(fix);
        }
        for (Tuple tuple : fixes) {
            RebuildPlannerUtils.Rebuild reb1 = (RebuildPlannerUtils.Rebuild)tuple.getFirst();
            RebuildPlannerUtils.Rebuild reb2 = (RebuildPlannerUtils.Rebuild)tuple.getSecond();
            String prCode = null;
            Workplace wp = null;
            long end = 0L;
            if (reb1 == null) {
                prCode = "00100";
                wp = reb2.getWp();
                end = reb2.getExpectedStart();
            } else if (reb2 == null) {
                wp = reb1.getWp();
                WorkplaceActivity adjAction = Validator.findAdjacentAction(plan, wp, end = reb1.getEnd());
                prCode = adjAction == null ? "00200" : "00300";
            } else if (reb1.getRt() != reb2.getRt()) {
                prCode = "00400";
                wp = reb1.getWp();
                end = reb1.getEnd();
            } else if (reb1.getRebLength() != reb2.getRt().getTime()) {
                prCode = "00500";
                wp = reb1.getWp();
                end = reb1.getEnd();
            }
            Problem pr = null;
            if (prCode == null) continue;
            String date = Formatter.formatLongDateTime(end);
            pr = Problem.createProblem2(prCode, wp, date);
            res.add(pr);
        }
    }

    private static WorkplaceActivity findAdjacentAction(Plan plan, Workplace wp, long time) {
        WorkplaceSchedule wps = plan.getWorkplaceSchedule(wp);
        Iterator<WorkplaceActivity> it = wps.forwardIteratorWithBubblesCut(time);
        WorkplaceActivity nextWa = null;
        while (it.hasNext()) {
            WorkplaceActivity wa = it.next();
            if (wa instanceof CumulativeWorkplaceActivity || wa instanceof ActionActivity) {
                nextWa = wa;
                break;
            }
            if (wa instanceof Bubble || wa instanceof RebuildActivity) {
                nextWa = null;
                break;
            }
            if (wa instanceof OfflineActivity) continue;
            throw new IllegalArgumentException("unknown workplace activity type");
        }
        return nextWa;
    }

    private static void checkActionLengths(WorkplaceSchedule ws, List<Problem> res) {
        for (WorkplaceActivity wa : ws.activities()) {
            long actionSpecificTolerance;
            if (!(wa instanceof ActionActivity)) continue;
            ActionActivity aa = (ActionActivity)wa;
            long expectedDuration = aa.getAction().timeToMake(aa.getQty());
            long diff = Math.abs(aa.getDuration() - expectedDuration);
            GeneralizedActionRequest gar = aa.getGar();
            if (gar != null) {
                Action act = gar.getAction();
                actionSpecificTolerance = act.timeToMake(act.getGranularity());
            } else {
                actionSpecificTolerance = 0L;
                res.add(Problem.createProblem2("02650", aa));
            }
            if (diff <= 60000L || diff <= actionSpecificTolerance) continue;
            res.add(Problem.createProblem2("02700", aa, expectedDuration, aa.getDuration(), expectedDuration - aa.getDuration()));
        }
    }

    private static void checkNegativeStore(Plan plan, List<Problem> res) {
        StoreSchedule ss = plan.getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        for (Material m3 : plan.getShopConf().getMatprods()) {
            double lastQ = 0.0;
            for (Tuple<Long, Double> timeVal : ss.quantities(m3)) {
                if (Comparators.compare(lastQ, 0.0, 1.0E-7) >= 0 && Comparators.compare(timeVal.getSecond(), 0.0, 1.0E-7) < 0) {
                    res.add(Problem.createProblem2("02750", m3, timeVal.getSecond(), timeVal.getFirst()));
                }
                lastQ = timeVal.getSecond();
            }
        }
    }

    private static void checkMaxFills(WorkplaceSchedule workplaceSchedule, List<Problem> res) {
        IdentityHashSet<CumulativeAction> cas = new IdentityHashSet<CumulativeAction>();
        for (WorkplaceActivity wa : workplaceSchedule.activities()) {
            if (!(wa instanceof CumulativeWorkplaceActivity)) continue;
            CumulativeWorkplaceActivity cwa = (CumulativeWorkplaceActivity)wa;
            if (cwa.getConsumption() > 1.0000001) {
                res.add(Problem.createProblem2("02800", cwa, 100.0 * cwa.getConsumption()));
            }
            cas.clear();
            for (ActionActivity aa : cwa.getActionActivities()) {
                cas.add((CumulativeAction)aa.getAction());
            }
            for (CumulativeAction ca : cas) {
                double caQty = 0.0;
                for (ActionActivity aa : cwa.getActionActivities()) {
                    if (aa.getAction() != ca) continue;
                    caQty += aa.getQty();
                }
                if (!(caQty > ca.getMaxFill())) continue;
                res.add(Problem.createProblem2("02850", cwa, ca));
            }
        }
    }

    private static void checkPlanMembership(Plan plan, List<Problem> res) {
        for (Activity a : plan.activities()) {
            if (a.getPlan() == plan) continue;
            res.add(Problem.createProblem2("02900", a, a.getPlan()));
        }
    }

    public static ValidationResult validateForPlanning(Plan plan) {
        return new ValidationResult();
    }
}

